﻿<?php
	if (file_exists('lock')) {
		header('Location: ../admin.php');
		return;
	}
	require_once("../include/install.class.php");
	$install = new Install();
	
	if(isset($_GET['lang'])) {
		include('../language/'.$_GET["lang"].'.php');
	} else {
		include('../language/en.php');
		exit;
	}
	
	function url(){
	  return sprintf(
		"%s://%s%s",
		isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http',
		$_SERVER['SERVER_NAME'],
		$_SERVER['REQUEST_URI']
	  );
	}
	
	if ($_GET['lang']=="fa") {
		$site_url = str_replace("install/index.php?lang=fa","",url());
	} else if ($_GET['lang']=="en") {
		$site_url = str_replace("install/index.php?lang=en","",url());
	} else {
		exit;
	}
?>
<html>
	<head>
		<title><?php echo $lang['install']." - ".$lang['parscore']; ?></title>
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<script type="text/javascript" src="../assets/js/jquery-3.2.1.min.js"></script>
		<script type="text/javascript" src="../assets/js/bootstrap.js"></script>
		<link rel="stylesheet" href="../assets/css/font-awesome.css" />
		<link href="../assets/css/bootstrap.css" rel="stylesheet" media="screen">
		<link href="../assets/css/signin-<?php echo $_GET["lang"]; ?>.css" rel="stylesheet" media="screen">
	</head>
	<body>
		<div class="container">
			<div class="card card-container" style="max-width: 640px;">
				<h3 style="text-align:center"><?php echo $lang['install']; ?></h3>
				<form class="form-signin" method="post" action="">
					<input type="hidden" name="action" value="new" />
					<input type="hidden" name="siteurl" value="<?= $site_url; ?>" />
					<?php if (!empty($install->message)) { ?>
						<div id="message">
							<div class="<?=$install->alert; ?>" id="alert">
								<?=$install->message; ?>
							</div>
						</div>
					<?php } ?>
					<b><?php echo $lang['site_details']; ?></b>
					<div class="form-group">
						<label for="sitename"><?= $lang['sitename']; ?></label>
						<input type="text" class="form-control" name="sitename" id="sitename" autofocus aria-describedby="sitenameHelp" >
						<p id="sitenameHelp" class="form-text text-muted text-primary"><?= $lang['sitename_desp']; ?></p>
					</div>
					<b><?php echo $lang['database']; ?></b>
					<div class="form-group">
						<label for="dbhostname"><?= $lang['db_host']; ?></label>
						<input type="text" class="form-control" value="localhost" name="dbhostname" id="dbhostname" aria-describedby="dbhostnameHelp" >
						<p id="sitenameHelp" class="form-text text-muted text-primary"><?= $lang['dbhost_desp']; ?></p>
						<label for="dbdatabase"><?= $lang['db_name']; ?></label>
						<input type="text" class="form-control" name="dbdatabase" id="dbdatabase" aria-describedby="dbdatabaseHelp" >
						<p id="sitenameHelp" class="form-text text-muted text-primary"><?= $lang['dbname_desp']; ?></p>
						<label for="dbusername"><?= $lang['db_username']; ?></label>
						<input type="text" class="form-control" name="dbusername" id="dbusername" aria-describedby="dbusernameHelp" >
						<p id="sitenameHelp" class="form-text text-muted text-primary"><?= $lang['dbuser_desp']; ?></p>
						<label for="dbpassword"><?= $lang['db_password']; ?></label>
						<input type="password" class="form-control" name="dbpassword" id="dbpassword" aria-describedby="dbpasswordHelp" >
						<p id="sitenameHelp" class="form-text text-muted text-primary"><?= $lang['dbpass_desp']; ?></p>
					</div>
					<b><?php echo $lang['admin_user']; ?></b>
					<div class="form-group">
						<label for="adminusername"><?= $lang['admin_username']; ?></label>
						<input type="text" class="form-control" name="adminusername" id="adminusername" aria-describedby="adminusernameHelp" >
						<label for="adminemail"><?= $lang['admin_email']; ?></label>
						<input type="email" class="form-control" name="adminemail" id="adminemail" aria-describedby="adminemailHelp" >
						<p id="sitenameHelp" class="form-text text-muted text-primary"><?= $lang['adminemail_desp']; ?></p>
						<label for="adminpassword"><?= $lang['admin_password']; ?></label>
						<input type="password" class="form-control" name="adminpassword" id="adminpassword" aria-describedby="adminpasswordHelp" >
						<p id="sitenameHelp" class="form-text text-muted text-primary"><?= $lang['adminpass_desp']; ?></p>
					</div>
					<button class="btn btn-lg btn-primary btn-block btn-signin" type="submit"><?php echo $lang['install']; ?></button>
				</form>
			</div>
		</div>
		<div class="lang"><a href="index.php?lang=fa" data-balloon="<?= $lang['persian']; ?>" data-balloon-pos="right">فا</a>/ <a href="index.php?lang=en" data-balloon="<?= $lang['english']; ?>" data-balloon-pos="right">EN</a></div>
	</body>
</html>